<?php
include 'db.php';

$buttonvals = $_POST['buttonvals'] ?? '';
$sortbys = $_POST['sortbys'] ?? '';
$invoice = trim($_POST['invoice'] ?? '');

$query = "
    SELECT 
        pur.purchase_id,
        pur.purchase_no,
        pur.Created_date,
        pur.Grand_total,
        v.displayname,
        v.phonenumber,
        pur.Payment_status, 
        pur.Balance,
        GROUP_CONCAT(DISTINCT p.Product_name SEPARATOR '|') AS product_names,
        GROUP_CONCAT(DISTINCT p.Product_image SEPARATOR '|') AS product_images,
        (SELECT COUNT(*) FROM purchase_data WHERE purchase_data.purchase_id = pur.purchase_id AND purchase_data.Delete_status = 0) AS total_products
    FROM 
        purchase pur
    INNER JOIN 
        customer v ON v.id = pur.vendor_id
    INNER JOIN 
        purchase_data pd ON pd.purchase_id = pur.purchase_id AND pd.Delete_status = 0
    INNER JOIN 
        product p ON p.Product_id = pd.Product_id
    LEFT JOIN 
        payment vp ON vp.purchase_id = pur.purchase_id
    WHERE 
        pur.Delete_status = 0
";


// Add filters based on input
if (!empty($sortbys)) {
    $query .= " AND pur.status = '$sortbys'";
}
if (!empty($invoice)) {
    $invoice = mysqli_real_escape_string($conn, $invoice); // Sanitize input
    $query .= " AND (LOWER(pur.purchase_no) LIKE '%$invoice%' 
                  OR LOWER(v.displayname) LIKE '%$invoice%' 
                  OR LOWER(v.phoneno) LIKE '%$invoice%')";
}
if ($buttonvals == '3') {
    $today = date('Y-m-d'); 
    $query .= " AND pur.Created_date = '$today'";
}
if ($buttonvals == '4') {
    $yesterday = date("Y-m-d", strtotime("yesterday")); 
    $query .= " AND pur.Created_date = '$yesterday'";
}
if ($buttonvals == '5') {
    $query .= " AND pur.Created_date >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
}

$query .= " GROUP BY pur.purchase_id, pur.purchase_no, pur.Created_date, pur.Grand_total, v.displayname, pur.Payment_status";

$result = mysqli_query($conn, $query);  

if (!$result) {
    die("Database query failed: " . mysqli_error($conn));
}

$data = array();
while ($row = mysqli_fetch_assoc($result)) {
    $id = $row['purchase_id'];
    $purchaseno = $row['purchase_no'];
    $Created_date = $row['Created_date'];
    $grandtotal = $row['Grand_total'];
    $displayname = $row['displayname'];
    $phoneno = $row['phonenumber'];
    $status = $row['Payment_status'];
    $balance = $row['Balance'];
    $product_names = explode('|', $row['product_names']);
    $product_images = explode('|', $row['product_images']);
    $totalProducts= $row['total_products'];

    $user_details = array(
        'id' => $id,
        'estimateno' => $purchaseno,
        'purchasedate' => $Created_date,
        'grandtotal' => $grandtotal,
        'balance' => empty($balance) ? '-' : $balance,
        'status' => $status,
        'displayname' => $displayname,
        'phoneno' => $phoneno,
        'product_names' => $product_names,
        'product_images' => $product_images,
        'totalProducts' => $totalProducts
    );
    $data[] = $user_details;
}

echo json_encode($data);

mysqli_close($conn);
?>